<?php
// Start the session
session_start();

// Include database connection file
include('includes/dbconn.php');

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

require 'phpmailer/PHPMailer/src/Exception.php';
require 'phpmailer/PHPMailer/src/PHPMailer.php';
require 'phpmailer/PHPMailer/src/SMTP.php';

//include('phpmailer/PHPMailer/PHPMailerAutoload.php'); // Ensure this path is correct

function sendPasswordResetEmail($email, $newPassword) {
    //$mail = new PHPMailer;
    $mail = new PHPMailer(true);

    // SMTP Configuration
    $mail->isSMTP();
    $mail->Host = 'mail.jaysfinancials.com';
    $mail->SMTPAuth = true;
    $mail->Username = 'smtp2@jaysfinancials.com';
    $mail->Password = '#@#2024JF';
    $mail->SMTPSecure = 'tls';
    $mail->Port = 587;

    // Email settings
    $mail->setFrom('smtp2@jaysfinancials.com', 'Faida Accounting System');
    $mail->addAddress($email);
    $mail->Subject = 'Your Faida Accounting System Password Has Been Reset';
    $mail->Body    = 'Your new password is: ' . $newPassword;

    if(!$mail->send()) {
        throw new Exception('Mailer Error: ' . $mail->ErrorInfo);
    }
}


function generateNewPassword() {
    return bin2hex(random_bytes(8)); // Generates a secure random password
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = $_POST['emailaddress'];

    // Generate a new random password
    $newPassword = generateNewPassword();

    // Hash the new password before storing it
    $passwordHash = password_hash($newPassword, PASSWORD_DEFAULT);

    // Update the new password in the database
    $sql = "UPDATE users SET password_hash = ? WHERE email = ?";
    $stmt = $conn->prepare($sql);

    if (!$stmt) {
        echo "Error: " . $conn->error;
        exit;
    }

    $stmt->bind_param("ss", $passwordHash, $email);
    $stmt->execute();

    if ($stmt->affected_rows > 0) {
    try {
        // Send email with the new password
        sendPasswordResetEmail($email, $newPassword);

        // Output the success HTML with the logo and style adjustments for centering
        echo '<style>
                .centered-content {
                    display: flex;
                    flex-direction: column;
                    align-items: center;
                    justify-content: center;
                    height: 100vh; /* Full viewport height */
                }
                .auth-logo {
                    text-align: center;
                    margin-bottom: 20px; /* Add some space below the logo */
                }
                .logout-checkmark svg {
                    width: 50px;  /* Adjust the width as needed */
                    height: 50px; /* Adjust the height as needed */
                    margin-bottom: 20px; /* Add some space below the checkmark */
                }
              </style>
              <div class="auth-logo">
                  <a href="index.php" class="logo text-center">
                      <span class="logo-lg">
                          <img src="assets/images/faida-logo.png" alt="" height="40">
                      </span>
                  </a>
              </div>
              <div class="centered-content">
                <div class="logout-checkmark">
                    <!-- SVG for checkmark -->
                    <svg version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 130.2 130.2">
                        <circle class="path circle" fill="none" stroke="#4bd396" stroke-width="6" stroke-miterlimit="10" cx="65.1" cy="65.1" r="62.1"/>
                        <polyline class="path check" fill="none" stroke="#4bd396" stroke-width="6" stroke-linecap="round" stroke-miterlimit="10" points="100.2,40.2 51.5,88.8 29.8,67.5 "/>
                    </svg>
                </div>
                <h3>See you again!</h3>
                <p class="text-muted">Your password has been reset.</p>
              </div>
              <script>
                setTimeout(function() {
                    window.location.href = "auth-login.php"; // Replace with your login page URL
                }, 5000);
              </script>';

    } catch (Exception $e) {
        echo 'Error: ' . $e->getMessage();
    }
} else {
    echo 'No account found with that email address.';
}
    
    $stmt->close();
    $conn->close();
    }
?>
